<?php
    function registerUser(mysqli $conn, array $data) {
      $stmt = $conn->prepare("INSERT INTO `users`( `name`, `email`, `phone`, `password`, `role`) VALUES (?,?,?,?,?)");
      $stmt->bind_param("ssssi", $data['name'], $data['email'], $data['phone'], $data['password'], $data['role']);
      return ($stmt->execute()) ? $stmt->insert_id : false;
    }
    function selectUserByEmail(mysqli $conn, string $email) {
      $stmt = $conn->prepare('SELECT * FROM users WHERE email = ? AND deleted_at IS NULL');
      $stmt->bind_param('s', $email);
      $stmt->execute();
      return $stmt->get_result()->fetch_assoc();
    }
?>